<?php
require_once __DIR__ . 'db.php';
session_start();

if (!isset($_SESSION['user']) || $_SESSION['user']['role'] !== 'admin') {
    http_response_code(403);
    echo json_encode(['error' => 'Unauthorized']);
    exit;
}

$roomId = $_POST['room_id'] ?? null;

if ($roomId) {
    $stmt = $pdo->prepare("UPDATE rooms SET status = 'available' WHERE id = ?");
    $success = $stmt->execute([$roomId]);

    echo json_encode(['success' => $success]);
} else {
    echo json_encode(['error' => 'Room ID not provided']);
}
?>
