<?php
// includes/mail_functions.php

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

require __DIR__ . '/../vendor/autoload.php'; // Path to PHPMailer autoload

/**
 * Send an email using SMTP
 * 
 * @param array $options - Email options including:
 *   - to_email: Recipient email
 *   - to_name: Recipient name
 *   - subject: Email subject
 *   - body: HTML email content
 *   - alt_body: Plain text alternative (optional)
 * @return bool True if sent successfully, false otherwise
 */
function sendEmail($options) {
    $mail = new PHPMailer(true);
    
    try {
        // Server settings
        $mail->isSMTP();
        $mail->Host       = 'mail.sheridanhotelsnsuites.com'; // Your SMTP server
        $mail->SMTPAuth   = true;
        $mail->Username   = 'bookingorder@sheridanhotelsnsuites.com'; // SMTP username
        $mail->Password   = '@Mail4sheridan#2025';     // SMTP password
        $mail->SMTPSecure = PHPMailer::ENCRYPTION_SMTPS; // TLS or SSL
        $mail->Port       = 465; // 587 for TLS
        
        $mail->DKIM_domain = 'sheridanhotelsnsuites.com';
        $mail->DKIM_private = 'private.key'; // DKIM private key
        $mail->DKIM_selector = 'selector1'; // Your DKIM selector
        $mail->DKIM_passphrase = ''; // Passphrase if any
        $mail->DKIM_identity = $mail->From;





        // Recipients
        $mail->setFrom('bookingorder@sheridanhotelsnsuites.com', 'Sheridan Hotel');
        $mail->addAddress($options['to_email'], $options['to_name']);
        
        // Reply-to (optional)
        $mail->addReplyTo('bookingorder@sheridanhotelsnsuites.com', 'Booking');
        
        // Content
        $mail->isHTML(true);
        $mail->Subject = $options['subject'];
        $mail->Body    = $options['body'];
        $mail->AltBody = $options['alt_body'] ?? strip_tags($options['body']);
        
        $mail->send();
        return true;
    } catch (Exception $e) {
        error_log("Mailer Error: " . $mail->ErrorInfo);
        return false;
    }
}

/**
 * Generate booking confirmation email content
 */
function generateBookingEmail($booking_details) {
    ob_start(); ?>
    <!DOCTYPE html>
    <html>
    <head>
        <style>
            body { font-family: Arial, sans-serif; line-height: 1.6; }
            .container { max-width: 600px; margin: 0 auto; padding: 20px; }
            .header { background-color: #667eea; color: white; padding: 20px; text-align: center; }
            .content { padding: 20px; background-color: #f8fafc; }
            .details { background-color: white; padding: 15px; margin: 15px 0; }
            .footer { margin-top: 20px; font-size: 12px; text-align: center; }
        </style>
    </head>
    <body>
        <div class="container">
            <div class="header">
                <h1>Booking Confirmation</h1>
            </div>
            <div class="content">
                <p>Dear <?= htmlspecialchars($booking_details['guest_name']) ?>,</p>
                <p>Thank you for your booking at Sheridan Hotel. Here are your reservation details:</p>
                
                <div class="details">
                    <p><strong>Booking ID:</strong> <?= $booking_details['booking_id'] ?></p>
                    <p><strong>Room:</strong> <?= htmlspecialchars($booking_details['room_type']) ?></p>
                    <p><strong>Check-in:</strong> <?= $booking_details['check_in'] ?></p>
                    <p><strong>Check-out:</strong> <?= $booking_details['check_out'] ?></p>
                    <p><strong>Total Amount:</strong> <?= $booking_details['total_amount'] ?></p>
                </div>
                
                <p>If you have any questions, please contact our support team.</p>
                
                <div class="footer">
                    <p>&copy; <?= date('Y') ?> Sheridan Hotel. All rights reserved.</p>
                </div>
            </div>
        </div>
    </body>
    </html>
    <?php
    return ob_get_clean();
}

/**
 * Generate staff welcome email content
 */
function generateStaffWelcomeEmail($staff_details) {
    ob_start(); ?>
    <!DOCTYPE html>
    <html>
    <head>
        <style>
            body { font-family: Arial, sans-serif; line-height: 1.6; }
            .container { max-width: 600px; margin: 0 auto; padding: 20px; }
            .header { background-color: #764ba2; color: white; padding: 20px; text-align: center; }
            .content { padding: 20px; background-color: #f8fafc; }
            .credentials { background-color: white; padding: 15px; margin: 15px 0; }
            .footer { margin-top: 20px; font-size: 12px; text-align: center; }
        </style>
    </head>
    <body>
        <div class="container">
            <div class="header">
                <h1>Welcome to Sheridan Hotel Staff</h1>
            </div>
            <div class="content">
                <p>Dear <?= htmlspecialchars($staff_details['name']) ?>,</p>
                <p>Your staff account has been successfully created. Here are your login credentials:</p>
                
                <div class="credentials">
                    <p><strong>Email:</strong> <?= htmlspecialchars($staff_details['email']) ?></p>
                    <p><strong>Password:</strong> <?= htmlspecialchars($staff_details['password']) ?></p>
                    <p><strong>Role:</strong> <?= ucfirst($staff_details['role']) ?></p>
                    <p><strong><em>We strongly recommend you change your password as you login (click on your profile name to change your password)</em></strong></p>

                </div>
                
                <p>Please log in at: <a href="https://booking.shridanhotelsnsuites.com/">Admin Portal</a></p>
                <p>For security reasons, please change your password after first login.</p>
                
                <div class="footer">
                    <p>&copy; <?= date('Y') ?> Sheridan Hotel. All rights reserved.</p>
                </div>
            </div>
        </div>
    </body>
    </html>
    <?php
    return ob_get_clean();
}
?>