<?php
session_start();
require_once __DIR__ . '/../includes/db.php';

if (!isset($_SESSION['user'])) {
    header("Location: ../index.php");
    exit;
}
$admin = $_SESSION['user'];

$message = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['booking_id'])) {
    $bookingId = $_POST['booking_id'];

    // Mark booking as checked out
    $updateBooking = $pdo->prepare("UPDATE bookings SET status = 'checked_out' WHERE id = ?");
    $updateBooking->execute([$bookingId]);

    // Set room status to available
    $getRoomId = $pdo->prepare("SELECT room_id FROM bookings WHERE id = ?");
    $getRoomId->execute([$bookingId]);
    $roomId = $getRoomId->fetchColumn();

    if ($roomId) {
        $updateRoom = $pdo->prepare("UPDATE rooms SET status = 'available' WHERE id = ?");
        $updateRoom->execute([$roomId]);
    }

    $message = "Guest checked out successfully!";
}

// Fetch active bookings (checked-in)
$stmt = $pdo->query("
    SELECT b.id, c.full_name AS guest_name, b.check_in, b.check_out, b.total_amount, r.room_number
    FROM bookings b
    JOIN rooms r ON b.room_id = r.id
    JOIN customers c ON b.customer_id = c.id
    WHERE b.status = 'pending'
    ORDER BY b.check_out ASC
");
$bookings = $stmt->fetchAll();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Check-Out Guests</title>
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
</head>
<body class="bg-gray-100 flex h-screen">
    <aside class="w-64 bg-white shadow-md h-full flex flex-col">
    <div class="p-6">
        <h1 class="text-xl font-bold text-blue-700">Sheridan Hotel</h1>
        <p class="text-gray-600 mb-6">Logged in as <strong><?= $admin['role'] ?></strong></p>
    </div>
    <nav class="flex-1 px-4 space-y-2">
        <a href="dashboard.php" class="block px-4 py-2 text-gray-700 rounded hover:bg-gray-200">Dashboard Home</a>
        <a href="book_room.php" class="block px-4 py-2 text-gray-700 rounded hover:bg-gray-200">Book a Room</a>
        <a href="room_status.php" class="block px-4 py-2 text-gray-700 rounded hover:bg-gray-200">Check Room Status</a>
        <a href="available_rooms.php" class="block px-4 py-2 text-gray-700 rounded hover:bg-gray-200">Available Rooms</a>
        <a href="check_out.php" class="block px-4 py-2 bg-blue-100 text-blue-800 rounded">Customer Check-out</a>
        <a href="list_booked.php" class="block px-4 py-2 text-gray-700 rounded hover:bg-gray-200">List of Booked Rooms</a>
    </nav>
    <div class="p-4 border-t">
        <p class="text-sm text-gray-500">&copy; Sheridan Hotels and Suites</p>
        <a href="../logout.php" class="text-red-500 hover:underline text-sm">Logout</a>
    </div>
</aside>



<div class="flex-1 flex flex-col overflow-hidden">

<!-- Top Navbar -->
    <nav class="bg-white shadow px-6 py-4 flex justify-between items-center">
        <h1 class="text-xl font-bold text-gray-800">Dashboard Overview</h1>
        <div class="flex items-center gap-4">
            <span class="text-gray-600 text-sm">Welcome, <?= htmlspecialchars($admin['name']) ?>  <span id="datetime"></span>
    <script>setInterval(() => document.getElementById('datetime').textContent = new Date().toLocaleString(undefined, { hour12: false }), 1000);</script></span>
             
            
        </div>
    </nav>

    <div class="max-w-4xl mx-auto bg-white p-6 rounded shadow">
        <h2 class="text-2xl font-bold mb-4">Check-Out Guests</h2>

        <?php if ($message): ?>
            <div class="mb-4 p-3 bg-green-100 text-green-800 border border-green-300 rounded">
                <?= htmlspecialchars($message) ?>
            </div>
        <?php endif; ?>

        <?php if (count($bookings) > 0): ?>
            <table class="w-full table-auto border-collapse mb-6">
                <thead>
                    <tr class="bg-gray-200 text-left">
                        <th class="p-2 border">Room</th>
                        <th class="p-2 border">Guest</th>
                        <th class="p-2 border">Check-In</th>
                        <th class="p-2 border">Check-Out</th>
                        <th class="p-2 border">Amount</th>
                        <th class="p-2 border">Action</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($bookings as $booking): ?>
                        <tr class="border-t">
                            <td class="p-2 border"><?= htmlspecialchars($booking['room_number']) ?></td>
                            <td class="p-2 border"><?= htmlspecialchars($booking['guest_name']) ?></td>
                            <td class="p-2 border"><?= htmlspecialchars($booking['check_in']) ?></td>
                            <td class="p-2 border"><?= htmlspecialchars($booking['check_out']) ?></td>
                            <td class="p-2 border">₦<?= number_format($booking['total_amount'], 2) ?></td>
                            <td class="p-2 border">
                                <form method="POST" onsubmit="return confirm('Confirm check-out?')">
                                    <input type="hidden" name="booking_id" value="<?= $booking['id'] ?>">
                                    <button type="submit" class="bg-blue-600 hover:bg-blue-700 text-white px-3 py-1 rounded">
                                        Check-Out
                                    </button>
                                </form>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        <?php else: ?>
            <p>No guests currently checked in.</p>
        <?php endif; ?>
    </div>
</div>
</body>
</html>
