<?php
require_once __DIR__ . '/../includes/db.php';
session_start();

if (!isset($_SESSION['user'])) {
    header("Location: ../index.php");
    exit;
}

$admin = $_SESSION['user'];

// Fetch available rooms
$stmt = $pdo->query("SELECT r.id, r.room_number, r.price_per_night, c.name AS category 
                     FROM rooms r 
                     JOIN room_categories c ON r.category_id = c.id 
                     WHERE r.status = 'available'");
$rooms = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Available Rooms</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100 flex h-screen">
<aside class="w-64 bg-white shadow-md h-full flex flex-col">
    <div class="p-6">
        <h1 class="text-xl font-bold text-blue-700">Sheridan Hotel</h1>
        <p class="text-gray-600 mb-6">Logged in as <strong><?= $admin['role'] ?></strong></p>
    </div>
    <nav class="flex-1 px-4 space-y-2">
        <a href="dashboard.php" class="block px-4 py-2 text-gray-700 rounded hover:bg-gray-200">Dashboard Home</a>
        <a href="book_room.php" class="block px-4 py-2 text-gray-700 rounded hover:bg-gray-200">Book a Room</a>
        <a href="room_status.php" class="block px-4 py-2 text-gray-700 rounded hover:bg-gray-200">Check Room Status</a>
        <a href="available_rooms.php" class="block px-4 py-2 bg-blue-100 text-blue-800 rounded">Available Rooms</a>
        <a href="check_out.php" class="block px-4 py-2 text-gray-700 rounded hover:bg-gray-200">Customer Check-out</a>
        <a href="list_booked.php" class="block px-4 py-2 text-gray-700 rounded hover:bg-gray-200">List of Booked Rooms</a>
    </nav>
    <div class="p-4 border-t">
        <p class="text-sm text-gray-500">&copy; Sheridan Hotels and Suites</p>
        <a href="../logout.php" class="text-red-500 hover:underline text-sm">Logout</a>
    </div>
</aside>

<div class="flex-1 flex flex-col overflow-hidden">
    <nav class="bg-white shadow px-6 py-4 flex justify-between items-center">
        <h1 class="text-xl font-bold text-gray-800">Available Rooms</h1>
        <span class="text-gray-600 text-sm">Welcome, <?= htmlspecialchars($admin['name']) ?> 
            <span id="datetime"></span>
            <script>
                setInterval(() => document.getElementById('datetime').textContent = new Date().toLocaleString(undefined, { hour12: false }), 1000);
            </script>
        </span>
    </nav>

    <div class="p-6">
        <?php if (count($rooms) > 0): ?>
            <table class="min-w-full bg-white shadow rounded overflow-hidden">
                <thead class="bg-blue-600 text-white">
                    <tr>
                        <th class="px-4 py-2 text-left">Room Number</th>
                        <th class="px-4 py-2 text-left">Category</th>
                        <th class="px-4 py-2 text-left">Price</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($rooms as $room): ?>
                        <tr class="border-b hover:bg-gray-50">
                            <td class="px-4 py-2"><?= htmlspecialchars($room['room_number']) ?></td>
                            <td class="px-4 py-2"><?= htmlspecialchars($room['category']) ?></td>
                            <td class="px-4 py-2">₦<?= number_format($room['price_per_night'], 2) ?></td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        <?php else: ?>
            <div class="bg-yellow-100 text-yellow-800 p-4 rounded">No rooms available at the moment.</div>
        <?php endif; ?>
    </div>
</div>
</body>
</html>
