<?php
require_once '../includes/db.php';

// Fetch categories for filtering
$categoriesStmt = $pdo->query("SELECT id, name FROM room_categories");
$categories = $categoriesStmt->fetchAll(PDO::FETCH_ASSOC);

// Handle filters
$statusFilter = $_GET['status'] ?? '';
$categoryFilter = $_GET['category'] ?? '';

// Build query
$query = "SELECT r.*, c.name AS category_name FROM rooms r 
          JOIN room_categories c ON r.category_id = c.id 
          WHERE 1";

$params = [];

if ($statusFilter) {
    $query .= " AND r.status = ?";
    $params[] = $statusFilter;
}
if ($categoryFilter) {
    $query .= " AND r.category_id = ?";
    $params[] = $categoryFilter;
}

$stmt = $pdo->prepare($query);
$stmt->execute($params);
$rooms = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>
