 
<?php
// admin_register.php
require'./HMS/includes/db.php';

$message = '';

if ($_SERVER["REQUEST_METHOD"] === "POST") {
    $name     = $_POST['name'];
    $email    = $_POST['email'];
    $password = password_hash($_POST['password'], PASSWORD_DEFAULT);
    $role     = $_POST['role'];

    $stmt = $pdo->prepare("INSERT INTO users (name, email, password, role) VALUES (?, ?, ?, ?)");
    
    try {
        $stmt->execute([$name, $email, $password, $role]);
        $message = "User registered successfully!";
    } catch (PDOException $e) {
        $message = "Error: " . $e->getMessage();
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Admin Registration</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100 flex items-center justify-center h-screen">

<div class="bg-white p-8 rounded shadow-md w-full max-w-md">
    <h2 class="text-2xl font-bold mb-6 text-center">Register Admin/Staff</h2>

    <?php if ($message): ?>
        <div class="bg-green-100 text-green-700 px-4 py-2 rounded mb-4"><?= $message ?></div>
    <?php endif; ?>

    <form method="POST">
        <input type="text" name="name" placeholder="Full Name" required class="w-full px-4 py-2 mb-4 border rounded">
        <input type="email" name="email" placeholder="Email" required class="w-full px-4 py-2 mb-4 border rounded">
        <input type="password" name="password" placeholder="Password" required class="w-full px-4 py-2 mb-4 border rounded">
        
        <select name="role" class="w-full px-4 py-2 mb-4 border rounded" required>
            <option value="admin">Admin</option>
            <option value="staff">Staff</option>
        </select>

        <button type="submit" class="w-full bg-blue-600 text-white px-4 py-2 rounded hover:bg-blue-700">
            Register
        </button>
    </form>
</div>

</body>
</html>
