<?php
require_once __DIR__ . '/../includes/check_room_status.php';


session_start();
if (!isset($_SESSION['user']) || $_SESSION['user']['role'] !== 'admin') {
    header("Location: ../index.php");
    exit;
}

$limit = 10;
$page = $_GET['page'] ?? 1;
$offset = ($page - 1) * $limit;

$stmt = $pdo->prepare("SELECT r.*, c.name AS category_name 
                       FROM rooms r 
                       JOIN room_categories c ON r.category_id = c.id 
                       ORDER BY r.id DESC 
                       LIMIT $limit OFFSET $offset");
$stmt->execute();
$rooms = $stmt->fetchAll();

$totalStmt = $pdo->query("SELECT COUNT(*) FROM rooms");
$totalRooms = $totalStmt->fetchColumn();
$totalPages = ceil($totalRooms / $limit);








?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Check Room Status</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100 p-6">

    <div class="max-w-7xl mx-auto bg-white p-6 rounded shadow">
        <h2 class="text-2xl font-bold mb-4">Room Status Overview</h2>

        <!-- Filters -->
        <form method="GET" class="flex gap-4 mb-6">
            <select name="status" class="border p-2 rounded">
                <option value="">All Statuses</option>
                <option value="available" <?= $statusFilter == 'available' ? 'selected' : '' ?>>Available</option>
                <option value="booked" <?= $statusFilter == 'booked' ? 'selected' : '' ?>>Booked</option>
                <option value="occupied" <?= $statusFilter == 'occupied' ? 'selected' : '' ?>>Occupied</option>
                <option value="maintenance" <?= $statusFilter == 'maintenance' ? 'selected' : '' ?>>Under Maintenance</option>
            </select>

            <select name="category" class="border p-2 rounded">
                <option value="">All Categories</option>
                <?php foreach ($categories as $cat): ?>
                    <option value="<?= $cat['id'] ?>" <?= $categoryFilter == $cat['id'] ? 'selected' : '' ?>>
                        <?= htmlspecialchars($cat['name']) ?>
                    </option>
                <?php endforeach; ?>
            </select>

            <button type="submit" class="bg-blue-600 text-white px-4 py-2 rounded hover:bg-blue-700">Filter</button>
        </form>

        <!-- Table -->
        <div class="overflow-x-auto">
            <div class="p-6">
    <h2 class="text-2xl font-bold mb-4">Room Status</h2>

    <table class="min-w-full bg-white shadow-md rounded mb-4">
        <thead>
            <tr class="bg-gray-100 text-left text-sm font-semibold text-gray-700">
                <th class="py-3 px-4">Room Number</th>
                <th class="py-3 px-4">Category</th>
                <th class="py-3 px-4">Status</th>
                <th class="py-3 px-4">Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($rooms as $room): ?>
                <tr class="border-b">
                    <td class="py-2 px-4"><?= htmlspecialchars($room['room_number']) ?></td>
                    <td class="py-2 px-4"><?= htmlspecialchars($room['category_name']) ?></td>
                    <td class="py-2 px-4"><?= ucfirst($room['status']) ?></td>
                    <td class="py-2 px-4 space-x-2">
                        <?php if ($room['status'] === 'available'): ?>
                            <a href="book_room.php?room_id=<?= $room['id'] ?>" class="bg-blue-500 text-white px-3 py-1 rounded hover:bg-blue-600 text-sm">Book Now</a>
                        <?php elseif ($room['status'] === 'dirty'): ?>
                            <a href="mark_cleaned.php?room_id=<?= $room['id'] ?>" class="bg-green-500 text-white px-3 py-1 rounded hover:bg-green-600 text-sm">Mark as Cleaned</a>
                        <?php else: ?>
                            <span class="text-gray-500 text-sm">No Action</span>
                        <?php endif; ?>
                    </td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>

    <!-- Pagination -->
    <div class="flex justify-center mt-4 space-x-2">
        <?php for ($i = 1; $i <= $totalPages; $i++): ?>
            <a href="?page=<?= $i ?>" class="px-3 py-1 border rounded <?= $i == $page ? 'bg-blue-500 text-white' : 'bg-white text-gray-700 hover:bg-gray-100' ?>">
                <?= $i ?>
            </a>
        <?php endfor; ?>
    </div>
</div>

        </div>
    </div>

</body>
</html>
