<?php
require_once __DIR__ . '/../includes/check_room_status.php';
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Check Room Status</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100 p-6">

    <div class="max-w-7xl mx-auto bg-white p-6 rounded shadow">
        <h2 class="text-2xl font-bold mb-4">Room Status Overview</h2>

        <!-- Filters -->
        <form method="GET" class="flex gap-4 mb-6">
            <select name="status" class="border p-2 rounded">
                <option value="">All Statuses</option>
                <option value="available" <?= $statusFilter == 'available' ? 'selected' : '' ?>>Available</option>
                <option value="booked" <?= $statusFilter == 'booked' ? 'selected' : '' ?>>Booked</option>
                <option value="occupied" <?= $statusFilter == 'occupied' ? 'selected' : '' ?>>Occupied</option>
                <option value="maintenance" <?= $statusFilter == 'maintenance' ? 'selected' : '' ?>>Under Maintenance</option>
            </select>

            <select name="category" class="border p-2 rounded">
                <option value="">All Categories</option>
                <?php foreach ($categories as $cat): ?>
                    <option value="<?= $cat['id'] ?>" <?= $categoryFilter == $cat['id'] ? 'selected' : '' ?>>
                        <?= htmlspecialchars($cat['name']) ?>
                    </option>
                <?php endforeach; ?>
            </select>

            <button type="submit" class="bg-blue-600 text-white px-4 py-2 rounded hover:bg-blue-700">Filter</button>
        </form>

        <!-- Table -->
        <div class="overflow-x-auto">
            <table class="min-w-full bg-white">
                <thead>
                    <tr class="bg-gray-200 text-left">
                        <th class="px-4 py-2">Room Number</th>
                        <th class="px-4 py-2">Category</th>
                        <th class="px-4 py-2">Status</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (count($rooms) > 0): ?>
                        <?php foreach ($rooms as $room): ?>
                            <tr class="border-b">
                                <td class="px-4 py-2"><?= htmlspecialchars($room['room_number']) ?></td>
                                <td class="px-4 py-2"><?= htmlspecialchars($room['category_name']) ?></td>
                                <td class="px-4 py-2">
                                    <span class="px-2 py-1 text-sm rounded 
                                        <?= match($room['status']) {
                                            'available' => 'bg-green-100 text-green-700',
                                            'booked' => 'bg-yellow-100 text-yellow-700',
                                            'occupied' => 'bg-red-100 text-red-700',
                                            'maintenance' => 'bg-gray-100 text-gray-700',
                                            default => 'bg-blue-100 text-blue-700'
                                        } ?>">
                                        <?= ucfirst($room['status']) ?>
                                    </span>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <tr><td colspan="3" class="text-center py-4 text-gray-500">No rooms found for this filter.</td></tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>

</body>
</html>
