<?php
// dashboard.php
session_start();
require_once 'includes/db.php';

if (!isset($_SESSION['admin'])) {
    header('Location: admin_login.php');
    exit;
}

$admin = $_SESSION['admin'];
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Dashboard Home - Sheridan Hotel</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="flex">

<!-- Sidebar -->
<aside class="w-64 bg-white shadow-md h-screen flex flex-col">
    <div class="p-6">
        <h1 class="text-xl font-bold text-blue-700">Sheridan Hotel</h1>
        <p class="text-sm text-gray-500 mt-1">Admin Dashboard</p>
    </div>
    <nav class="flex-1 px-4 space-y-2">
        <a href="dashboard.php" class="block px-4 py-2 text-gray-700 rounded hover:bg-gray-200">Dashboard Home</a>
        <a href="book_room.php" class="block px-4 py-2 text-gray-700 rounded hover:bg-gray-200">Book a Room</a>
        <a href="room_status.php" class="block px-4 py-2 text-gray-700 rounded hover:bg-gray-200">Check Room Status</a>
        <a href="available_rooms.php" class="block px-4 py-2 text-gray-700 rounded hover:bg-gray-200">Available Rooms</a>
        <a href="list_available.php" class="block px-4 py-2 text-gray-700 rounded hover:bg-gray-200">List of Available Rooms</a>
        <a href="list_booked.php" class="block px-4 py-2 text-gray-700 rounded hover:bg-gray-200">List of Booked Rooms</a>
    </nav>
    <div class="p-4 border-t">
        <p class="text-sm text-gray-500">Welcome, <?= htmlspecialchars($admin['name']) ?></p>
        <a href="logout.php" class="mt-2 inline-block text-red-500 hover:underline text-sm">Logout</a>
    </div>
</aside>

<!-- Main Content -->
<main class="flex-1 bg-gray-100 min-h-screen p-6">
    <!-- Top Navbar -->
    <nav class="bg-white shadow px-6 py-4 flex justify-between items-center mb-6">
        <h1 class="text-xl font-bold text-gray-800">Dashboard Overview</h1>
        <div class="flex items-center gap-4">
            <span class="text-gray-600 text-sm">Welcome, <?= htmlspecialchars($admin['name']) ?></span>
            <a href="logout.php" class="bg-red-500 text-white px-4 py-2 rounded hover:bg-red-600 text-sm">Logout</a>
        </div>
    </nav>

    <!-- Metrics Grid -->
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
        <div class="bg-white p-6 rounded shadow">
            <h2 class="text-gray-700 font-semibold">Available Rooms</h2>
            <p class="text-3xl font-bold text-green-600">25</p>
        </div>
        <div class="bg-white p-6 rounded shadow">
            <h2 class="text-gray-700 font-semibold">Rooms Booked Today</h2>
            <p class="text-3xl font-bold text-blue-600">18</p>
        </div>
        <div class="bg-white p-6 rounded shadow">
            <h2 class="text-gray-700 font-semibold">Rooms Booked This Week</h2>
            <p class="text-3xl font-bold text-blue-500">72</p>
        </div>
        <div class="bg-white p-6 rounded shadow">
            <h2 class="text-gray-700 font-semibold">Rooms Booked This Month</h2>
            <p class="text-3xl font-bold text-indigo-600">320</p>
        </div>
        <div class="bg-white p-6 rounded shadow">
            <h2 class="text-gray-700 font-semibold">Soon Available Rooms</h2>
            <p class="text-3xl font-bold text-yellow-600">8</p>
        </div>
        <div class="bg-white p-6 rounded shadow">
            <h2 class="text-gray-700 font-semibold">Revenue Today</h2>
            <p class="text-3xl font-bold text-green-600">₦210,000</p>
        </div>
        <div class="bg-white p-6 rounded shadow">
            <h2 class="text-gray-700 font-semibold">Revenue This Week</h2>
            <p class="text-3xl font-bold text-green-500">₦840,000</p>
        </div>
        <div class="bg-white p-6 rounded shadow">
            <h2 class="text-gray-700 font-semibold">Revenue This Month</h2>
            <p class="text-3xl font-bold text-green-700">₦3,200,000</p>
        </div>
        <div class="bg-white p-6 rounded shadow">
            <h2 class="text-gray-700 font-semibold">Most Booked Room Category</h2>
            <p class="text-2xl font-bold text-purple-700">Deluxe Suite</p>
        </div>
        <div class="bg-white p-6 rounded shadow">
            <h2 class="text-gray-700 font-semibold">Peak Booking Time</h2>
            <p class="text-2xl font-bold text-red-600">6:00 PM - 9:00 PM</p>
        </div>
    </div>

    <!-- Optional Clock -->
    <div class="mt-8 text-sm text-gray-500 text-center">
        Current Time: <span id="datetime"></span>
    </div>
    <script>
        setInterval(() => {
            document.getElementById('datetime').textContent = new Date().toLocaleString('en-GB', { hour12: false });
        }, 1000);
    </script>

</main>

</body>
</html>
