 
<?php
// admin/dashboard.php
session_start();
require_once __DIR__ . '/../includes/datafetch.php';
require_once __DIR__ . '/../includes/db.php';
if (!isset($_SESSION['user'])) {
    header("Location: ../index.php");
    exit;
}
$admin = $_SESSION['user'];
?>

<!DOCTYPE html>
<html>
<head>
    <title>Admin Dashboard</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <!--<link href="../src/output.css" rel="stylesheet">-->
</head>
<body class="bg-gray-100 flex h-screen">
    <!-- Sidebar -->
<aside class="w-64 bg-white shadow-md h-full flex flex-col">
    <div class="p-6">
        <h1 class="text-xl font-bold text-blue-700">Sheridan Hotel</h1>
        <!--<p class="text-sm text-gray-500 mt-1">Admin Dashboard</p>-->
        <p class="text-gray-600 mb-6">You are logged in as <strong><?= $admin['role'] ?></strong>.</p>
    </div>
    <nav class="flex-1 px-4 space-y-2">
        <a href="dashboard.php" class="block px-4 py-2 text-gray-700 rounded hover:bg-gray-200">Dashboard Home</a>
        <a href="book_room.php" class="block px-4 py-2 text-gray-700 rounded hover:bg-gray-200">Book a Room</a>
        <a href="room_status.php" class="block px-4 py-2 text-gray-700 rounded hover:bg-gray-200">Check Room Status</a>
        <a href="available_rooms.php" class="block px-4 py-2 text-gray-700 rounded hover:bg-gray-200">Available Rooms</a>
        <a href="list_available.php" class="block px-4 py-2 text-gray-700 rounded hover:bg-gray-200">List of Available Rooms</a>
        <a href="list_booked.php" class="block px-4 py-2 text-gray-700 rounded hover:bg-gray-200">List of Booked Rooms</a>
    </nav>
    <div class="p-4 border-t">
        <p class="text-sm text-gray-500">All right reserved &copy;Sheridan Hotels and suits
 </p>
        <a href="../logout.php" class="mt-2 inline-block text-red-500 hover:underline text-sm">Logout</a>
    </div>
</aside>

<!-- Dashboard Body -->
 <!-- Content Area -->
<!-- Main content area -->
<div class="flex-1 flex flex-col overflow-hidden">

    <!-- Top Navbar -->
    <nav class="bg-white shadow px-6 py-4 flex justify-between items-center">
        <h1 class="text-xl font-bold text-gray-800">Dashboard Overview</h1>
        <div class="flex items-center gap-4">
            <span class="text-gray-600 text-sm">Welcome, <?= htmlspecialchars($admin['name']) ?>  <span id="datetime"></span>
    <script>setInterval(() => document.getElementById('datetime').textContent = new Date().toLocaleString(undefined, { hour12: false }), 1000);</script></span>
             
            
        </div>
    </nav>

    <!-- Content Area -->
    <main class="p-6 overflow-y-auto">
        <h2 class="text-2xl font-semibold mb-6"></h2>

        <!-- Metrics Grid -->
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
        <div class="bg-white p-6 rounded shadow">
            <h2 class="text-gray-700 font-semibold">Available Rooms</h2>
            <p class="text-3xl font-bold text-green-600">25</p>
        </div>
        <div class="bg-white p-6 rounded shadow">
            <h2 class="text-gray-700 font-semibold">Rooms Booked Today</h2>
            <p class="text-3xl font-bold text-blue-600"><?=$bookedToday?></p>
        </div>
        <div class="bg-white p-6 rounded shadow">
            <h2 class="text-gray-700 font-semibold">Rooms Booked This Week</h2>
            <p class="text-3xl font-bold text-blue-500"><?= $bookedThisWeek?></p>
        </div>
        <div class="bg-white p-6 rounded shadow">
            <h2 class="text-gray-700 font-semibold">Rooms Booked This Month</h2>
            <p class="text-3xl font-bold text-indigo-600"><?=$bookedThisMonth?></p>
        </div>
        <div class="bg-white p-6 rounded shadow">
            <h2 class="text-gray-700 font-semibold">Soon Available Rooms</h2>
            <p class="text-3xl font-bold text-yellow-600"><?=$soonAvailable?></p>
         ?></p>
        </div>
        <div class="bg-white p-6 rounded shadow">
            <h2 class="text-gray-700 font-semibold">Revenue Today</h2>
            <p class="text-3xl font-bold text-green-600">₦<?=number_format($revenueToday)?></p>
        </div>
        <div class="bg-white p-6 rounded shadow">
            <h2 class="text-gray-700 font-semibold">Revenue This Week</h2>
            <p class="text-3xl font-bold text-green-500">₦840,000</p>
        </div>
        <div class="bg-white p-6 rounded shadow">
            <h2 class="text-gray-700 font-semibold">Revenue This Month</h2>
            <p class="text-3xl font-bold text-green-700">₦3,200,000</p>
        </div>
        <div class="bg-white p-6 rounded shadow">
            <h2 class="text-gray-700 font-semibold">Most Booked Room Category</h2>
            <p class="text-2xl font-bold text-purple-700">Deluxe Suite</p>
        </div>
        <div class="bg-white p-6 rounded shadow">
            <h2 class="text-gray-700 font-semibold">Peak Booking Time</h2>
            <p class="text-2xl font-bold text-red-600">6:00 PM - 9:00 PM</p>
        </div>
    </div>
    </main>
    <!--<h1 class="text-3xl font-bold mb-4">Welcome, <?= htmlspecialchars($admin['name']) ?> 👋</h1>-->
    

    
</div>



   
</body>
</html>
