 
<?php
// admin/dashboard.php
session_start();
if (!isset($_SESSION['user'])) {
    header("Location: ../index.php");
    exit;
}
$admin = $_SESSION['user'];
?>

<!DOCTYPE html>
<html>
<head>
    <title>Admin Dashboard</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100 flex h-screen overflow-hidden">
    <!-- Sidebar -->
<aside class="w-64 bg-white shadow-md h-full flex flex-col">
    <div class="p-6">
        <h1 class="text-xl font-bold text-blue-700">Sheridan Hotel</h1>
        <p class="text-sm text-gray-500 mt-1">Admin Dashboard</p>
    </div>
    <nav class="flex-1 px-4 space-y-2">
        <a href="dashboard.php" class="block px-4 py-2 text-gray-700 rounded hover:bg-gray-200">Dashboard Home</a>
        <a href="book_room.php" class="block px-4 py-2 text-gray-700 rounded hover:bg-gray-200">Book a Room</a>
        <a href="room_status.php" class="block px-4 py-2 text-gray-700 rounded hover:bg-gray-200">Check Room Status</a>
        <a href="available_rooms.php" class="block px-4 py-2 text-gray-700 rounded hover:bg-gray-200">Available Rooms</a>
        <a href="list_available.php" class="block px-4 py-2 text-gray-700 rounded hover:bg-gray-200">List of Available Rooms</a>
        <a href="list_booked.php" class="block px-4 py-2 text-gray-700 rounded hover:bg-gray-200">List of Booked Rooms</a>
    </nav>
    <div class="p-4 border-t">
        <p class="text-sm text-gray-500">Welcome, <?= htmlspecialchars($admin['name']) ?></p>
        <a href="logout.php" class="mt-2 inline-block text-red-500 hover:underline text-sm">Logout</a>
    </div>
</aside>
    <!-- Navigation Bar -->
<nav class="bg-white shadow px-6 py-4 flex justify-between items-center">
    <h1 class="text-xl font-bold text-gray-800">Sheridan Hotel & Suites</h1>
    <div class="flex items-center gap-4">
        <span class="text-gray-600 text-sm">Welcome, <?= htmlspecialchars($admin['name']) ?></span>
        <a href="logout.php" class="bg-red-500 text-white px-4 py-2 rounded hover:bg-red-600 text-sm">Logout</a>
    </div>
</nav>

<!-- Dashboard Body -->
<div class="p-6 grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6 max-w-6xl mx-auto mt-8">

    <!-- Dashboard Card -->
    <a href="book_room.php" class="bg-blue-600 text-white rounded-xl p-6 shadow hover:bg-blue-700 transition">
        <h2 class="text-lg font-bold mb-2">Book a Room</h2>
        <p class="text-sm">Reserve a room for a customer.</p>
    </a>

    <a href="room_status.php" class="bg-purple-600 text-white rounded-xl p-6 shadow hover:bg-purple-700 transition">
        <h2 class="text-lg font-bold mb-2">Check Room Status</h2>
        <p class="text-sm">View the occupancy and cleanliness status.</p>
    </a>

    <a href="available_rooms.php" class="bg-green-600 text-white rounded-xl p-6 shadow hover:bg-green-700 transition">
        <h2 class="text-lg font-bold mb-2">Check Available Rooms</h2>
        <p class="text-sm">Quick lookup for currently available rooms.</p>
    </a>

    <a href="list_available.php" class="bg-yellow-500 text-white rounded-xl p-6 shadow hover:bg-yellow-600 transition">
        <h2 class="text-lg font-bold mb-2">List of Available Rooms</h2>
        <p class="text-sm">Browse all available rooms by category.</p>
    </a>

    <a href="list_booked.php" class="bg-red-500 text-white rounded-xl p-6 shadow hover:bg-red-600 transition">
        <h2 class="text-lg font-bold mb-2">List of Booked Rooms</h2>
        <p class="text-sm">View all current bookings.</p>
    </a>

    <a href="dashboard.php" class="bg-gray-800 text-white rounded-xl p-6 shadow hover:bg-gray-900 transition">
        <h2 class="text-lg font-bold mb-2">Refresh Dashboard</h2>
        <p class="text-sm">Reload this page.</p>
    </a>
</div>

    <h1 class="text-3xl font-bold mb-4">Welcome, <?= htmlspecialchars($admin['name']) ?> 👋</h1>
    <p class="text-gray-600 mb-6">You are logged in as <strong><?= $admin['role'] ?></strong>.</p>

    <a href="../logout.php" class="inline-block bg-red-500 text-white px-4 py-2 rounded hover:bg-red-600">Logout</a>
</body>
</html>
