 
<?php
// admin/dashboard.php
session_start();
if (!isset($_SESSION['user'])) {
    header("Location: ../index.php");
    exit;
}
$admin = $_SESSION['user'];
?>

<!DOCTYPE html>
<html>
<head>
    <title>Admin Dashboard</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100 min-h-screen">
    <!-- Navigation Bar -->
<nav class="bg-white shadow px-6 py-4 flex justify-between items-center">
    <h1 class="text-xl font-bold text-gray-800">Sheridan Hotel & Suites</h1>
    <div class="flex items-center gap-4">
        <span class="text-gray-600 text-sm">Welcome, <?= htmlspecialchars($user['name']) ?></span>
        <a href="logout.php" class="bg-red-500 text-white px-4 py-2 rounded hover:bg-red-600 text-sm">Logout</a>
    </div>
</nav>

    <h1 class="text-3xl font-bold mb-4">Welcome, <?= htmlspecialchars($admin['name']) ?> 👋</h1>
    <p class="text-gray-600 mb-6">You are logged in as <strong><?= $admin['role'] ?></strong>.</p>

    <a href="../logout.php" class="inline-block bg-red-500 text-white px-4 py-2 rounded hover:bg-red-600">Logout</a>
</body>
</html>
