<?php
// admin/dashboard.php
session_start();
require_once __DIR__ . '/../includes/datafetch.php';
require_once __DIR__ . '/../includes/db.php';
if (!isset($_SESSION['user'])) {
    header("Location:./index.php");
    exit;
}
$admin = $_SESSION['user'];
?>

<!DOCTYPE html>
<html>
<head>
    <title>Admin Dashboard</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap');
        
        body {
            font-family: 'Inter', sans-serif;
        }
        
        .gradient-bg {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        }
        
        .card-hover {
            transition: all 0.3s ease;
        }
        
        .card-hover:hover {
            transform: translateY(-5px);
            box-shadow: 0 20px 25px -5px rgba(0, 0, 0, 0.1), 0 10px 10px -5px rgba(0, 0, 0, 0.04);
        }
        
        .nav-item {
            transition: all 0.2s ease;
            position: relative;
            overflow: hidden;
        }
        
        .nav-item:hover {
            background: linear-gradient(135deg, #f3f4f6, #e5e7eb);
            transform: translateX(5px);
        }
        
        .nav-item.active {
            background: linear-gradient(135deg, #3b82f6, #1d4ed8);
            color: white;
        }
        
        .metric-card {
            background: linear-gradient(135deg, #ffffff, #f8fafc);
            border: 1px solid rgba(255, 255, 255, 0.2);
            backdrop-filter: blur(10px);
        }
        
        .sidebar-gradient {
            background: linear-gradient(180deg, #1e293b 0%, #334155 100%);
        }
        
        .animate-fade-in {
            animation: fadeIn 0.8s ease-in-out;
        }
        
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(20px); }
            to { opacity: 1; transform: translateY(0); }
        }
        
        .pulse-dot {
            animation: pulse 2s infinite;
        }
        
        @keyframes pulse {
            0%, 100% { transform: scale(1); opacity: 1; }
            50% { transform: scale(1.1); opacity: 0.8; }
        }
    </style>
</head>
<body class="bg-gradient-to-br from-gray-50 to-gray-100 min-h-screen">
    <!-- Sidebar -->
    <aside class="fixed left-0 top-0 w-72 h-full sidebar-gradient shadow-2xl z-50">
        <div class="p-8">
            <div class="flex items-center gap-3 mb-2">
                <div class="w-10 h-10 bg-gradient-to-r from-blue-400 to-purple-500 rounded-xl flex items-center justify-center">
                    <i class="fas fa-hotel text-white text-lg"></i>
                </div>
                <h1 class="text-2xl font-bold text-white">Sheridan Hotel</h1>
            </div>
            <div class="flex items-center gap-2 mt-4 p-3 bg-white/10 rounded-lg backdrop-blur-sm">
                <div class="w-2 h-2 bg-green-400 rounded-full pulse-dot"></div>
                <p class="text-white/90 text-sm">Logged in as <span class="font-semibold text-blue-300"><?= $admin['role'] ?></span></p>
            </div>
        </div>
        
        <nav class="px-6 space-y-2">
            <a href="dashboard.php" class="nav-item active flex items-center gap-3 px-4 py-3 text-white rounded-xl">
                <i class="fas fa-tachometer-alt w-5"></i>
                <span class="font-medium">Dashboard Home</span>
            </a>
            <a href="book_room.php" class="nav-item flex items-center gap-3 px-4 py-3 text-white/80 hover:text-white rounded-xl">
                <i class="fas fa-calendar-plus w-5"></i>
                <span class="font-medium">Book a Room</span>
            </a>
            <a href="room_status.php" class="nav-item flex items-center gap-3 px-4 py-3 text-white/80 hover:text-white rounded-xl">
                <i class="fas fa-bed w-5"></i>
                <span class="font-medium">Room Status</span>
            </a>
            <a href="check_out.php" class="nav-item flex items-center gap-3 px-4 py-3 text-white/80 hover:text-white rounded-xl">
                <i class="fas fa-sign-out-alt w-5"></i>
                <span class="font-medium">Customer Check-out</span>
            </a>
            <a href="list_booked.php" class="nav-item flex items-center gap-3 px-4 py-3 text-white/80 hover:text-white rounded-xl">
                <i class="fas fa-list-alt w-5"></i>
                <span class="font-medium">Booked Rooms</span>
            </a>
            <!--<a href="list_all_rooms.php" class="nav-item flex items-center gap-3 px-4 py-3 text-white/80 hover:text-white rounded-xl">
                <i class="fas fa-building w-5"></i>
                <span class="font-medium">All Rooms</span>
            </a>-->
            
        </nav>
        
        <div class="absolute bottom-0 left-0 right-0 p-6 border-t border-white/10">
            <p class="text-white/60 text-xs mb-3">© Sheridan Hotels and Suites</p>
            <a href="../logout.php" class="flex items-center gap-2 text-red-400 hover:text-red-300 text-sm font-medium transition-colors">
                <i class="fas fa-power-off"></i>
                <span>Logout</span>
            </a>
        </div>
    </aside>

    <!-- Main Content Area -->
    <div class="ml-72 min-h-screen">
        <!-- Top Header -->
        <header class="bg-white/80 backdrop-blur-sm border-b border-gray-200/50 px-8 py-6 sticky top-0 z-40">
            <div class="flex justify-between items-center">
                <div>
                    <h1 class="text-3xl font-bold text-gray-800">Dashboard Overview</h1>
                    <p class="text-gray-600 mt-1">Monitor your hotel operations in real-time</p>
                </div>
                <div class="flex items-center gap-6">
                    <div class="text-right">
                        <p class="text-sm text-gray-500">Welcome back,</p>
                        <p class="font-semibold text-gray-800"><a href="My_profile.php"><?= htmlspecialchars($admin['name']) ?></a></p>
                    </div>
                    <div class="w-12 h-12 bg-gradient-to-r from-blue-500 to-purple-600 rounded-full flex items-center justify-center text-white font-bold text-lg">
                        <?= strtoupper(substr($admin['name'], 0, 1)) ?>
                    </div>
                    <div class="text-sm text-gray-600 font-mono bg-gray-100 px-3 py-2 rounded-lg">
                        <span id="datetime"></span>
                    </div>
                </div>
            </div>
        </header>

        <!-- Dashboard Content -->
        <main class="p-8">
            <!-- Quick Stats Banner -->
            <div class="bg-gradient-to-r from-blue-600 via-purple-600 to-blue-800 rounded-2xl p-8 mb-8 text-white animate-fade-in">
                <div class="flex items-center justify-between">
                    <div>
                        <h2 class="text-2xl font-bold mb-2">Hotel Performance Today</h2>
                        <p class="text-blue-100">Real-time insights into your business metrics</p>
                    </div>
                    <div class="text-6xl opacity-20">
                        <i class="fas fa-chart-line"></i>
                    </div>
                </div>
            </div>

            <!-- Metrics Grid -->
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 xl:grid-cols-4 gap-6 mb-8">
                <!-- Available Rooms -->
                <div class="metric-card card-hover p-6 rounded-2xl shadow-lg">
                    <div class="flex items-center justify-between mb-4">
                        <div class="w-12 h-12 bg-green-100 rounded-full flex items-center justify-center">
                            <i class="fas fa-door-open text-green-600 text-xl"></i>
                        </div>
                        <div class="text-right">
                            <div class="w-3 h-3 bg-green-500 rounded-full"></div>
                        </div>
                    </div>
                    <h3 class="text-gray-600 font-medium mb-2">Available Rooms</h3>
                    <p class="text-3xl font-bold text-green-600 mb-1"><?=$availableRooms?></p>
                    <p class="text-xs text-gray-500">Ready for booking</p>
                </div>

                <!-- Rooms Booked Today -->
                <div class="metric-card card-hover p-6 rounded-2xl shadow-lg">
                    <div class="flex items-center justify-between mb-4">
                        <div class="w-12 h-12 bg-blue-100 rounded-full flex items-center justify-center">
                            <i class="fas fa-calendar-check text-blue-600 text-xl"></i>
                        </div>
                        <div class="text-right">
                            <div class="w-3 h-3 bg-blue-500 rounded-full"></div>
                        </div>
                    </div>
                    <h3 class="text-gray-600 font-medium mb-2">Booked Today</h3>
                    <p class="text-3xl font-bold text-blue-600 mb-1"><?=$bookedToday?></p>
                    <p class="text-xs text-gray-500">New reservations</p>
                </div>

                <!-- Rooms Booked This Week -->
                <div class="metric-card card-hover p-6 rounded-2xl shadow-lg">
                    <div class="flex items-center justify-between mb-4">
                        <div class="w-12 h-12 bg-indigo-100 rounded-full flex items-center justify-center">
                            <i class="fas fa-calendar-week text-indigo-600 text-xl"></i>
                        </div>
                        <div class="text-right">
                            <div class="w-3 h-3 bg-indigo-500 rounded-full"></div>
                        </div>
                    </div>
                    <h3 class="text-gray-600 font-medium mb-2">Weekly Bookings</h3>
                    <p class="text-3xl font-bold text-indigo-600 mb-1"><?= $bookedThisWeek?></p>
                    <p class="text-xs text-gray-500">This week's total</p>
                </div>

                <!-- Rooms Booked This Month -->
                <div class="metric-card card-hover p-6 rounded-2xl shadow-lg">
                    <div class="flex items-center justify-between mb-4">
                        <div class="w-12 h-12 bg-purple-100 rounded-full flex items-center justify-center">
                            <i class="fas fa-calendar-alt text-purple-600 text-xl"></i>
                        </div>
                        <div class="text-right">
                            <div class="w-3 h-3 bg-purple-500 rounded-full"></div>
                        </div>
                    </div>
                    <h3 class="text-gray-600 font-medium mb-2">Monthly Bookings</h3>
                    <p class="text-3xl font-bold text-purple-600 mb-1"><?=$bookedThisMonth?></p>
                    <p class="text-xs text-gray-500">This month's total</p>
                </div>

                <!-- Soon Available Rooms -->
                <div class="metric-card card-hover p-6 rounded-2xl shadow-lg">
                    <div class="flex items-center justify-between mb-4">
                        <div class="w-12 h-12 bg-yellow-100 rounded-full flex items-center justify-center">
                            <i class="fas fa-clock text-yellow-600 text-xl"></i>
                        </div>
                        <div class="text-right">
                            <div class="w-3 h-3 bg-yellow-500 rounded-full"></div>
                        </div>
                    </div>
                    <h3 class="text-gray-600 font-medium mb-2">Soon Available</h3>
                    <p class="text-3xl font-bold text-yellow-600 mb-1"><?=$soonAvailable?></p>
                    <p class="text-xs text-gray-500">Upcoming checkouts</p>
                </div>

                <!-- Revenue Today -->
                <div class="metric-card card-hover p-6 rounded-2xl shadow-lg">
                    <div class="flex items-center justify-between mb-4">
                        <div class="w-12 h-12 bg-emerald-100 rounded-full flex items-center justify-center">
                            <i class="fas fa-money-bill-wave text-emerald-600 text-xl"></i>
                        </div>
                        <div class="text-right">
                            <div class="w-3 h-3 bg-emerald-500 rounded-full"></div>
                        </div>
                    </div>
                    <h3 class="text-gray-600 font-medium mb-2">Today's Revenue</h3>
                    <p class="text-3xl font-bold text-emerald-600 mb-1">₦<?=number_format($revenueToday)?></p>
                    <p class="text-xs text-gray-500">Daily earnings</p>
                </div>

                <!-- Revenue This Week -->
                <div class="metric-card card-hover p-6 rounded-2xl shadow-lg">
                    <div class="flex items-center justify-between mb-4">
                        <div class="w-12 h-12 bg-teal-100 rounded-full flex items-center justify-center">
                            <i class="fas fa-chart-bar text-teal-600 text-xl"></i>
                        </div>
                        <div class="text-right">
                            <div class="w-3 h-3 bg-teal-500 rounded-full"></div>
                        </div>
                    </div>
                    <h3 class="text-gray-600 font-medium mb-2">Weekly Revenue</h3>
                    <p class="text-3xl font-bold text-teal-600 mb-1">₦<?=number_format($revenueWeek)?></p>
                    <p class="text-xs text-gray-500">Week's earnings</p>
                </div>

                <!-- Revenue This Month -->
                <div class="metric-card card-hover p-6 rounded-2xl shadow-lg">
                    <div class="flex items-center justify-between mb-4">
                        <div class="w-12 h-12 bg-green-100 rounded-full flex items-center justify-center">
                            <i class="fas fa-chart-line text-green-700 text-xl"></i>
                        </div>
                        <div class="text-right">
                            <div class="w-3 h-3 bg-green-700 rounded-full"></div>
                        </div>
                    </div>
                    <h3 class="text-gray-600 font-medium mb-2">Monthly Revenue</h3>
                    <p class="text-3xl font-bold text-green-700 mb-1">₦<?=number_format($revenueMonth)?></p>
                    <p class="text-xs text-gray-500">Month's total</p>
                </div>

                <!-- Most Booked Room Category -->
                <div class="metric-card card-hover p-6 rounded-2xl shadow-lg">
                    <div class="flex items-center justify-between mb-4">
                        <div class="w-12 h-12 bg-pink-100 rounded-full flex items-center justify-center">
                            <i class="fas fa-star text-pink-600 text-xl"></i>
                        </div>
                        <div class="text-right">
                            <div class="w-3 h-3 bg-pink-500 rounded-full"></div>
                        </div>
                    </div>
                    <h3 class="text-gray-600 font-medium mb-2">Top Category</h3>
                    <p class="text-2xl font-bold text-pink-600 mb-1"><?= $mostBookedCategory ? $mostBookedCategory['name'] : 'N/A' ?></p>
                    <p class="text-xs text-gray-500">Most popular</p>
                </div>

                <!-- Peak Booking Time -->
                <div class="metric-card card-hover p-6 rounded-2xl shadow-lg">
                    <div class="flex items-center justify-between mb-4">
                        <div class="w-12 h-12 bg-red-100 rounded-full flex items-center justify-center">
                            <i class="fas fa-fire text-red-600 text-xl"></i>
                        </div>
                        <div class="text-right">
                            <div class="w-3 h-3 bg-red-500 rounded-full"></div>
                        </div>
                    </div>
                    <h3 class="text-gray-600 font-medium mb-2">Peak Hour</h3>
                    <p class="text-2xl font-bold text-red-600 mb-1"><?=$peakHour ? $peakHour['hour'] . ":00" : "N/A" ?></p>
                    <p class="text-xs text-gray-500">Busiest time</p>
                </div>
            </div>

            <!-- Quick Actions -->
            <div class="bg-white rounded-2xl p-6 shadow-lg">
                <h3 class="text-xl font-semibold text-gray-800 mb-4">Quick Actions</h3>
                <div class="grid grid-cols-2 md:grid-cols-4 gap-4">
                    <a href="book_room.php" class="flex flex-col items-center p-4 bg-blue-50 hover:bg-blue-100 rounded-xl transition-colors">
                        <i class="fas fa-plus-circle text-blue-500 text-2xl mb-2"></i>
                        <span class="text-sm font-medium text-blue-700">Book Room</span>
                    </a>
                    <a href="room_status.php" class="flex flex-col items-center p-4 bg-green-50 hover:bg-green-100 rounded-xl transition-colors">
                        <i class="fas fa-search text-green-500 text-2xl mb-2"></i>
                        <span class="text-sm font-medium text-green-700">Check Status</span>
                    </a>
                    <a href="check_out.php" class="flex flex-col items-center p-4 bg-purple-50 hover:bg-purple-100 rounded-xl transition-colors">
                        <i class="fas fa-sign-out-alt text-purple-500 text-2xl mb-2"></i>
                        <span class="text-sm font-medium text-purple-700">Check Out</span>
                    </a>
                    <a href="list_booked.php" class="flex flex-col items-center p-4 bg-orange-50 hover:bg-orange-100 rounded-xl transition-colors">
                        <i class="fas fa-list text-orange-500 text-2xl mb-2"></i>
                        <span class="text-sm font-medium text-orange-700">View Bookings</span>
                    </a>
                </div>
            </div>
        </main>
    </div>

    <script>
        setInterval(() => {
            document.getElementById('datetime').textContent = new Date().toLocaleString(undefined, { 
                hour12: false,
                year: 'numeric',
                month: 'short',
                day: 'numeric',
                hour: '2-digit',
                minute: '2-digit',
                second: '2-digit'
            });
        }, 1000);
    </script>
</body>
</html>